<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ArtifactRegistry;

class VulnerabilityScanningConfig extends \Google\Model
{
  /**
   * @var string
   */
  public $enablementConfig;
  /**
   * @var string
   */
  public $enablementState;
  /**
   * @var string
   */
  public $enablementStateReason;
  /**
   * @var string
   */
  public $lastEnableTime;

  /**
   * @param string
   */
  public function setEnablementConfig($enablementConfig)
  {
    $this->enablementConfig = $enablementConfig;
  }
  /**
   * @return string
   */
  public function getEnablementConfig()
  {
    return $this->enablementConfig;
  }
  /**
   * @param string
   */
  public function setEnablementState($enablementState)
  {
    $this->enablementState = $enablementState;
  }
  /**
   * @return string
   */
  public function getEnablementState()
  {
    return $this->enablementState;
  }
  /**
   * @param string
   */
  public function setEnablementStateReason($enablementStateReason)
  {
    $this->enablementStateReason = $enablementStateReason;
  }
  /**
   * @return string
   */
  public function getEnablementStateReason()
  {
    return $this->enablementStateReason;
  }
  /**
   * @param string
   */
  public function setLastEnableTime($lastEnableTime)
  {
    $this->lastEnableTime = $lastEnableTime;
  }
  /**
   * @return string
   */
  public function getLastEnableTime()
  {
    return $this->lastEnableTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityScanningConfig::class, 'Google_Service_ArtifactRegistry_VulnerabilityScanningConfig');
